import numpy as np
import util

def test_diameter():
    num_points = 10000
    points = np.random.randn(num_points, 10)
    max_dist = 0
    for i in range(num_points):
        for j in range(num_points):
            dist = np.linalg.norm(points[i] - points[j])
            if(dist > max_dist):
                max_dist = dist
    
    estimated_diam = util.get_diameter(points, 100)
    estimated_point_diam = util.get_diameter_pointdiff(points, 100)
    assert(np.isclose(max_dist, estimated_point_diam, rtol=0.1))
    

def test_diam_reduction():
    num_points = 500
    points = np.random.randn(num_points, 10)
    estimated_diam = util.get_diameter_pointdiff(points, 100)
    normalized_points = points/estimated_diam
    true_max = 0
    for i in range(num_points):
        for j in range(num_points):
            dist = np.linalg.norm(points[i] - points[j])
            if(dist > true_max):
                true_max = dist
                
    max_dist = 0
    for i in range(num_points):
        for j in range(num_points):
            dist = np.linalg.norm(normalized_points[i] - normalized_points[j])
            if(dist > max_dist):
                max_dist = dist
                
    assert(np.isclose(max_dist, 1, rtol=0.1))
    

def test_diam_large():
    num_points = 100000
    points = np.random.randn(num_points, 10)
    estimated_diam = util.get_diameter_pointdiff(points, 100)
    normalized_points = points/estimated_diam
    mean = np.mean(normalized_points, axis=0)
    assert(mean.shape == (10,))
    dists = np.linalg.norm(normalized_points - mean, axis=1)
    assert(np.max(dists) < 1)
    